<?php
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['message' => 'Méthode non autorisée']);
    exit;
}

$json = file_get_contents('php://input');
$input = json_decode($json, true);

if (!is_array($input) || !isset($input['events']) || !isset($input['filename'])) {
    http_response_code(400);
    echo json_encode(['message' => 'Format JSON invalide']);
    exit;
}

$filename = $input['filename'];
$events = $input['events'];

// Optionnel : vérifier que l'extension est bien .json
if (pathinfo($filename, PATHINFO_EXTENSION) !== 'json') {
    http_response_code(400);
    echo json_encode(['message' => 'Extension de fichier invalide']);
    exit;
}

if (file_put_contents($filename, json_encode($events, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    echo json_encode(['message' => "Fichier '$filename' mis à jour avec succès"]);
} else {
    http_response_code(500);
    echo json_encode(['message' => 'Erreur lors de l\'écriture du fichier']);
}
?>