<!-- jsCalendar pour Deltacms -->

$(document).ready(function(){
	// Get elements
	var elements = {
	  // Calendar element
	  calendar : document.getElementById("events-calendar"),
		// Input element
		events : document.getElementById("events")
	}
	// Create the calendar
	elements.calendar.className = "clean-theme";
	var calendar = jsCalendar.new(elements.calendar);
	calendar.setLanguage(langJsCalendar);
	// Create events elements
	elements.title = document.createElement("div");
	elements.title.className = "title blockTitle";
	elements.events.appendChild(elements.title);
	elements.subtitle = document.createElement("div");
	elements.subtitle.className = "subtitle";
	elements.events.appendChild(elements.subtitle);
	elements.list = document.createElement("div");
	elements.list.className = "list";
	elements.events.appendChild(elements.list);
	var events = {};
	var date_format = "DD/MM/YYYY";
	var current = null;
	
	//Charger les événements depuis events_url(0).json
	const nocache = Date.now();
	fetch(baseUrl+'/jscalendar/events_'+url0+'.json?nocache='+nocache)
	.then(response => response.json())
	.then(data => {
	  events = data;
	  // Cercler les dates avec événements
	  for (let dateStr in events) {
		if (events.hasOwnProperty(dateStr) && Array.isArray(events[dateStr]) && events[dateStr].length > 0) {
		  let dateObj = jsCalendar.tools.stringToDate(dateStr);
		  calendar.select(dateObj);
		}
	  }
	  showEvents(current);
	})
	.catch(error => console.error('Erreur lors du chargement JSON :', error));
	
	// Afficher les évènements
	var showEvents = function(date){
	  // Date string
	  var id = jsCalendar.tools.dateToString(date, date_format, langJsCalendar);
	  // Set date
	  current = new Date(date.getTime());
	  // Set title
	  elements.title.textContent = id;
	  // Clear old events
	  elements.list.innerHTML = "";
	  // Add events on list
	  if (events.hasOwnProperty(id) && events[id].length) {
		// Number of events
		//elements.subtitle.textContent = events[id].length + " " + ((events[id].length > 1) ? "events" : "event");
		var div;
		var close;
		// For each event
		for (var i = 0; i < events[id].length; i++) {
		  div = document.createElement("div");
		  div.className = "event-item";
		  div.textContent = (i + 1) + ". " + events[id][i].name;
		  elements.list.appendChild(div);
		  if( groupJsCalendar > 1){
			  close = document.createElement("div");
			  close.className = "close";
			  close.textContent = "×";
			  div.appendChild(close);
			  close.addEventListener("click", (function (date, index) {
				return function () {
				  removeEvent(date, index);
				}
			  })(date, i), false);
		  }
		}
	  } else {
		//elements.subtitle.textContent = "No events";
	  }
	};
	
	// Supprimer des évènements
	var removeEvent = function (date, index) {
	  // Date string
	  var id = jsCalendar.tools.dateToString(date, date_format, langJsCalendar);
	  // If no events return
	  if (!events.hasOwnProperty(id)) {
		return;
	  }
	  // If not found
	  if (events[id].length <= index) {
		return;
	  }
	  // Remove event
	  events[id].splice(index, 1);
	  // If no events uncheck date
	  if (events[id].length === 0) {
		calendar.unselect(date);
	  }
	  // Mise à jour de events.json
	  saveToServer();
	  // Refresh events
	  showEvents(current);

	}

	// Show current date events
	showEvents(new Date());

	// Add events
	calendar.onDateClick(function(event, date){
	  // Update calendar date
	  calendar.set(date);
	  // Show events
	  showEvents(date);
	});

	// Ajouter un évènement
	document.getElementById("event-form").addEventListener("submit", function(e) {
	  e.preventDefault();
	  var name = document.getElementById("event-name").value.trim();
	  if (name === "") return;
	  var id = jsCalendar.tools.dateToString(current, date_format, langJsCalendar);
	  if (!events.hasOwnProperty(id)) {
		events[id] = [];
	  }
	  if (events[id].length === 0) {
		calendar.select(current);
	  }
	  events[id].push({ name: name });
	  saveToServer();
	  showEvents(current);
	  // Réinitialiser le champ
	  document.getElementById("event-name").value = "";
	});

				
	function saveToServer() {
	  // Nettoyer les dates sans événements (tableaux vides)
	  const cleanedEvents = {};
	  for (const date in events) {
		if (events[date] && events[date].length > 0) {
		  cleanedEvents[date] = events[date];
		}
	  }
	  fetch('./plugin/jscalendar/vendor/jscalendar/ressources/update-events.php', {
		method: 'POST',
		  headers: {
			'Content-Type': 'application/json'
		  },
		//body: JSON.stringify(cleanedEvents)
		  body: JSON.stringify({
			filename: '../../../../../'+baseUrl+'/jscalendar/events_'+url0+'.json',
			events: cleanedEvents
		  })
	  })
	  .then(response => response.json())
	  .then(data => {
		console.log(data.message);
	  })
	  .catch(error => {
		console.error('Erreur', error);
	  });
	}
});
