<!-- upload-img version 4.6 -->
<?php
ignore_user_abort(true);
set_time_limit(0);
$controluser = ($this->getUser('group') >= self::GROUP_ADMIN && $this->getUser('password') === $this->getInput('DELTA_USER_PASSWORD')) ?? false;
	// Langue de l'interface en, es ou fr
	if ($controluser == true) {
		$langue = $this->getData(['config', 'i18n', 'langAdmin']);
	}
	else {
		if (isset($_SESSION['langFrontEnd']) && isset($_SESSION['translationType']) && $_SESSION['translationType'] === 'site') {
			$langue = $_SESSION['langFrontEnd'];
		}
		else {
			$langue = $this->getData(['config', 'i18n', 'langBase']);
		}
	}
	if (file_exists('plugin/upload-img/lang/'. $langue .'/lex_uploadimg.php')) {
		include('plugin/upload-img/lang/'. $langue .'/lex_uploadimg.php');
	}
	else {
		include('plugin/upload-img/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) .'/lex_uploadimg.php');
	}

function separe($nom) {
	$separateurs = ['-','_','.'];
    return str_replace($separateurs, ' ', $nom);
}
function makedir($dir) {
	if (is_dir($dir) === false)
		mkdir($dir,0755);
		clearstatcache();
}
// détermination du nom du dossier
$dossier = '';
if($this->getData(['plugin','upload-img',$this->getUrl(0)])!==null){
    $dossier = $this->getUrl(0);
} else {
    // dossier prend le nom de la barre droite ou gauche associée à la page
    $barLeft = $this->getData(['page',$this->getUrl(0),'barLeft']);
    if($barLeft!=='' && $this->getData(['plugin','upload-img',$barLeft])!==null){
        $dossier = $barLeft;
    } else {
        $barRight = $this->getData(['page',$this->getUrl(0),'barRight']);
        if($barRight!=='' && $this->getData(['plugin','upload-img',$barRight])!==null){
            $dossier = $barRight;
        }
    }
}
// taille des miniatures
$tnlarge = 240;
$tnhaut = ($tnlarge/1.6);
// création des dossiers
$conteneur = 'site/file/source/upload-img';
makedir($conteneur);
$dirpath = $conteneur.'/'.$dossier;
makedir($dirpath);
$tndir = $dirpath.'/tn';
makedir($tndir);
// groupe utilisateur autorisé
$controleditor = ($this->getUser('group') >= self::GROUP_EDITOR && $this->getUser('password') === $this->getInput('DELTA_USER_PASSWORD')) ?? false;

if(!isset($_POST['uploadimg'])) {
	if ($controleditor == true) {
?>
<form id="formuploadimg" method="post" enctype="multipart/form-data">
  <label for="sendimage"><?=$text['uploadimg']['upload'][1]?> : </label>
  <input type="file" name="sendimage" id="sendimage" accept="image/*">
  <button type="submit" name="uploadimg"><?=$text['uploadimg']['upload'][2]?></button>
</form>
<?php } ?>
<div id="galerie">
<?php
	$recherche = glob($dirpath.'/*.{jp**,gif,png,avif,webp,JP**,GIF,PNG,AVIF,WEBP}', GLOB_BRACE);
	natcasesort($recherche);

foreach($recherche as $photo) {
	$nomfichier = pathinfo($photo, PATHINFO_FILENAME);
	$picname = preg_replace( '/[\W]/', '', $nomfichier);
	// détermination de la miniature
	$miniature = $tndir.'/tn_'.$picname.'.webp';
	// création de la miniature
if( !file_exists($miniature) ) {
	list($width, $height, $type, $attr) = getimagesize($photo);

	if ($height > $tnhaut) {
	$convert = $tnhaut/$height;
	$height = $tnhaut;
	$width = ceil($width*$convert);
	}
	if ($width > $tnlarge) {
	$convert = $tnlarge/$width;
	$width = $tnlarge;
	$height = ceil($height*$convert);
	}

	$largeur = (int)round($width);
	$hauteur = (int)round($height);

	switch ($type) {
		case 1:
		$img_in = imagecreatefromgif($photo);
		break;
		case 2:
		$img_in = imagecreatefromjpeg($photo);
		break;
		case 3:
		$img_in = imagecreatefrompng($photo);
		break;
		case 18:
		$webpContents = file_get_contents($photo);
		$anim = ( strpos($webpContents, 'ANIM') !== false || strpos($webpContents, 'ANMF') !== false );
		if ($anim === false) {
		$img_in = imagecreatefromwebp($photo);
		}
		else { $img_in = false; }
		break;
		case 19:
		$img_in = function_exists('imagecreatefromavif') ? imagecreatefromavif($photo) : false;
		break;
	}

		if (false !== $img_in) {
			imageinterlace($img_in, true);
			$img_out = imagecreatetruecolor($largeur, $hauteur) or die ('Unable to create a GD image stream');
		if ($type !== 2) {
			imagecolortransparent($img_out, imagecolorallocatealpha($img_out, 0, 0, 0, 127));
			imagealphablending($img_out, false);
			imagesavealpha($img_out, true);
		}
			imagecopyresampled($img_out, $img_in, 0, 0, 0, 0, imagesx($img_out), imagesy($img_out), imagesx($img_in), imagesy($img_in));
			imagewebp($img_out, $miniature, 80);
			imagedestroy($img_out);
		} else { $miniature = $photo; }
	}// /création de la miniature

	// suppression d'image
	if(isset($_POST[$picname])) {
		unlink($photo);
		if(file_exists($miniature)) {
		unlink($miniature);
	}
		echo '<script>document.location.href = "'.helper::baseUrl(true).$this->getUrl(0).'";</script>';
	}
	// affichage
	echo '<div>';
	echo '<a href="'.$photo.'" rel="gallery"><img src="'.$miniature.'" alt="'.separe($nomfichier).'"></a>';
	if ($controleditor == true) {
	echo '<form class="deletimg" id="'.$picname.'" method="post"><input type="hidden" name="'.$picname.'"><input type="submit" value="" data-tippy-content="'.$text['uploadimg']['upload'][3].' '.$nomfichier.'"></form>';
	}
	echo '</div>'.PHP_EOL;
}
?>
</div>
<?php
}
else {
$target_dir = $dirpath.'/';
$target_file = $target_dir . preg_replace('/[^[:alnum:]_.\-\/]/', '', basename($_FILES['sendimage']['name']));
$uploadOk = 1;
$imageFileType = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
// Si un fichier à été sélectionné
if(!empty($_FILES['sendimage']['tmp_name'])) {
// Check if image file is a actual image or fake image
  $check = getimagesize($_FILES['sendimage']['tmp_name']);
  if($check !== false) {
    echo $text['uploadimg']['upload'][4].' : '.$check['mime'].'.<br>';
    $uploadOk = 1;
  } else {
    echo $text['uploadimg']['upload'][5].'.<br>';
    $uploadOk = 0;
  }

// Check if file already exists
if (file_exists($target_file)) {
  echo $text['uploadimg']['upload'][6].'.<br>';
  $uploadOk = 0;
}

// Check file size (2000ko) limité par php.ini -> upload_max_filesize
if ($_FILES['sendimage']['size'] > 2000000) {
  echo $text['uploadimg']['upload'][7].'.<br>';
  $uploadOk = 0;
}

// Allow certain file formats
if (!in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'avif'])) {
  echo $text['uploadimg']['upload'][8].'.<br>';
  $uploadOk = 0;
}

// Check if $uploadOk is set to 0 by an error
if ($uploadOk == 0) {
  echo $text['uploadimg']['upload'][9].'.';
// if everything is ok, try to upload file
} else {
  if (move_uploaded_file($_FILES['sendimage']['tmp_name'], $target_file)) {
    echo $text['uploadimg']['upload'][12].' '.basename($target_file).' '.$text['uploadimg']['upload'][13].'.';
  } else {
    echo $text['uploadimg']['upload'][10].'.';
  }
}
}
else {
	echo $text['uploadimg']['upload'][11].'.<br>';
}
echo '<a href="'.helper::baseUrl(true).$this->getUrl(0).'"><h2 style="width: 20%; margin: 10px 40%; text-align: center;">&larr; '.$text['uploadimg']['upload'][0].'</h2></a>';
}
//adaptation de https://www.w3schools.com/php/php_file_upload.asp
?>
